-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.02.10
-- 
-- add all admin object for special formats - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************

update et_catalog_object_column_prop
set ind_is_required 	= 1
where (ordinal_position_pkey is not null and ordinal_position_pkey > 0)
or column_name = 'ind_active';

update et_catalog_object_column_prop
set colvalue_default  	= 1
where column_name = 'ind_active';

--
-- et_callable_access
--
update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('description', 'ind_active', 'callobject_type', 'conn_name', 'command') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name not in ('callable_object', 'description', 'ind_active', 'callobject_category')  then 1 else 0 end
   ,ind_editable_hidden = case when column_name not in ('callable_object', 'description', 'ind_active', 'callobject_category')  then 1 else 0 end
   ,colvalue_default 	= case when column_name in ('command')  then 'enter call command for ...' else colvalue_default end
where catalog_id = mdLookup_SysMDObject('et_callable_object') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('catalog_id', 'conn_name', 'object', 'description', 'ind_active') then 1 else ind_is_required end
   ,ind_is_read_only 	= case when column_name in ('ind_nolog_upload', 'sort_id') then 1 else 0 end
   ,ind_is_hidden 		= case when column_name in ('sort_id', 'format_file_prefix', 'username_owner', 'usergroupname_deputy', 'ind_nolog_upload') or column_name like 'ind_cust%'  then 1 else 0 end
   ,ind_editable_hidden = case when column_name in ('sort_id', 'format_file_prefix', 'username_owner', 'usergroupname_deputy', 'ind_nolog_upload') or column_name like 'ind_cust%' then 1 else 0 end
   ,colvalue_default 	= case when column_name in ('description')  then 'enter physical name' else colvalue_default end
where catalog_id = mdLookup_SysMDObject('et_catalog_object') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('description') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name not in ('catalog_id', 'instance_name', 'description', 'ind_active') then 1 else 0 end
   ,ind_editable_hidden = case when column_name not in ('catalog_id', 'instance_name', 'description', 'ind_active') then 1 else 0 end
   ,colvalue_default 	= case when column_name in ('description')  then 'enter description' else colvalue_default end
where catalog_id = mdLookup_SysMDObject('et_catalog_object_instance') 
;

update et_catalog_object_column_prop cp
set ind_is_required = case when column_name in ('conn_name', 'description', 'conn_type') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('et_connection') 
;

update et_catalog_object_column_prop cp
set ind_is_required = case when column_name in ('description', 'operand_1', 'column_type', 'operation') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('et_constraint') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('conn_name', 'ind_active_logfile', 'ind_active_logdb', 'callable_object') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name in ('callable_object', 'filename_log') then 1 else 0 end
   ,ind_editable_hidden = case when column_name in ('callable_object', 'filename_log') then 1 else 0 end
   ,colvalue_default 	= case when column_name = 'filename_log'       then 'log_useraction.log' 
                               when column_name = 'ind_active_logfile' then 0
                               when column_name = 'ind_active_logdb' then 1
                               else colvalue_default end
where catalog_id = mdLookup_SysMDObject('et_logging') 
; 

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('column_title_ui', 'column_heading_ui') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name in ('colvalue_default', 'column_heading_ui') then 1 else 0 end
   ,ind_editable_hidden = case when column_name in ('colvalue_default', 'column_heading_ui') then 1 else 0 end
where catalog_id = mdLookup_SysMDObject('et_format_collection_column') 
; 

update et_catalog_object_column_prop cp
join et_metadb_object mdo
on cp.catalog_id = mdo.catalog_id 
set ind_is_required 	= case when column_name in ('description', 'edittype') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name in ('param_edittype', 'textarea_rows', 'textarea_cols') then 1 else 0 end
   ,ind_editable_hidden = case when column_name in ('param_edittype', 'textarea_rows', 'textarea_cols') then 1 else 0 end
where mdo.object = 'et_format_domain_logical' 
; 

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('description', 'editsize', 'editmaxlength') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name in ('editsize', 'editmaxlength') then 1 else 0 end
   ,ind_editable_hidden = case when column_name in ('editsize', 'editmaxlength') then 1 else 0 end
where catalog_id = mdLookup_SysMDObject('et_format_domain_physical') 
; 

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('description', 'column_title_ui', 'column_heading_ui') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name in ('column_title_ui', 'column_heading_ui', 'colvalue_default') then 1 else 0 end
   ,ind_editable_hidden = case when column_name in ('column_title_ui', 'column_heading_ui', 'colvalue_default') then 1 else 0 end
where catalog_id = mdLookup_SysMDObject('et_format_domain_semantic') 
; 

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('description', 'lookup_type') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name in ('catalog_id_lookup', 'instance_name_lookup') then 1 else ind_is_hidden end
   ,ind_editable_hidden 		= case when column_name in ('catalog_id_lookup', 'instance_name_lookup') then 0 else ind_editable_hidden end
where catalog_id = mdLookup_SysMDObject('et_lookup') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('description', 'er_level', 'sortorder', 'ind_deploy', 'objabbrev', 'catalog_id', 'conn_name') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('et_metadb_object') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('linktype') then 1 else ind_is_required end
   ,ind_is_hidden 		= case when column_name in ('logical_link', 'linktype', 'ind_logical_link_default', 'grid_location_detail', 'icon_link') then 1 else ind_is_hidden end
   ,ind_editable_hidden = case when column_name in ('logical_link', 'linktype', 'ind_logical_link_default', 'grid_location_detail', 'icon_link') then 1 else ind_editable_hidden end
where catalog_id = mdLookup_SysMDObject('et_table_link') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('column_name_detail') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('et_table_link_detail') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('description', 'ind_active', 'targetpage', 'param_set') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('et_transaction') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('transaction_code', 'menu_label', 'description', 'menue_id_parent', 'sortorder') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('et_transaction_menu') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('param_value') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('et_transaction_parameter_set') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('type_msg', 'ind_stop_msg', 'text_msg') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('etx_message_text') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('seq_value_increment', 'seq_value_min', 'seq_value_max', 'seq_value_cur', 'ind_cycle') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('etx_sequence') 
;

update et_catalog_object_column_prop cp
set ind_is_required 	= case when column_name in ('cfg_value', 'description') then 1 else ind_is_required end
where catalog_id = mdLookup_SysMDObject('etx_system_config') 
;
